﻿using System;
using System.Collections.Generic;
using System.Text;
using IndianHealthService.BMXNet.Model;

namespace IndianHealthService.BMXNet.WinForm
{
    public class DesktopFramework
    {
        private BMXNetSession _bmx = null;

        public BMXNetSession Bmx
        {
            get { return _bmx; }
        }

        private DesktopSession _brokerSession = null;

        public DesktopSession FrameworkSession
        {
            get { return _brokerSession; }
            set { _brokerSession = value; }
        }

        private List<DesktopSession> _sessions = new List<DesktopSession>();

        public List<DesktopSession> Sessions
        {
            get { return _sessions; }
            set { _sessions = value; }
        }

        public static DesktopFramework OpenOn(BMXNetSession aSession)
        {
            DesktopFramework broker = new DesktopFramework();
            
            broker.Start(aSession);
            
            return broker;
        }

        internal void Start(BMXNetSession aSession)
        {
            this._bmx = aSession;

            DesktopUser user = new DesktopUser();
            user.Name = aSession.UserName;
            user.Ien = aSession.DUZ;
            this._user = user;

            this.FrameworkSession = (DesktopSession)this.OpenDesktopSession();
        }


        protected DesktopSession OpenDesktopSession()
        {
            DesktopSession session = new DesktopSession();

            this.Sessions.Add(session);
            session.Open(this, this.ConstructDesktopContext());

            return session;
        }

        private DesktopContext ConstructDesktopContext()
        {
            DesktopContext answer = new DesktopContext();

            if (this.FrameworkSession != null)
            {
                answer.ChangePatient(this.FrameworkSession.Context.Patient);
                answer.ChangeVisit(this.FrameworkSession.Context.Visit);
            }

            return answer;
        }


        public DesktopSession OpenSession()
        {
            return this.OpenDesktopSession();          
        }

        private EventRegistry _eventRegistry = new EventRegistry();

        internal EventRegistry EventRegistry
        {
            get { return _eventRegistry; }
            set { _eventRegistry = value; }
        }

        public bool ChangePatient(Patient aPatient, bool force)
        {
            bool canChange = true;

            foreach (DesktopSession each in this.Sessions)
            {
                canChange = canChange && each.DesktopContext.RequestCanChangePatient(aPatient, force);
            }

            if (canChange)
            {
                foreach (DesktopSession each in this.Sessions)
                {
                    each.DesktopContext.ChangePatient(aPatient);
                }
            }

            return canChange;
        }

        public bool ChangeVisit(Visit aVisit, bool force)
        {
            bool canChange = true;

            foreach (DesktopSession each in this.Sessions)
            {
                canChange = canChange && each.DesktopContext.RequestCanChangeVisit(aVisit, force);
            }

            if (canChange)
            {
                foreach (DesktopSession each in this.Sessions)
                {
                    each.DesktopContext.ChangeVisit(aVisit);
                }
            }

            return canChange;
        }


        public bool ChangeVisit(Visit aVisit)
        {
            return this.ChangeVisit(aVisit,false);
        }

        public bool ChangePatient(Patient aPatient)
        {
            return this.ChangePatient(aPatient,false);
        }

       
        private DesktopContext _context = null;

        public DesktopContext Context
        {
            get { return _context; }
            set { _context = value; }
        }

        private User _user = null;

        public User User
        {
            get { return _user; }
        }

        
    }
}
